<?php
require_once '../config.php';
verificarLogin();

$titulo = "Planos";

// Buscar planos DO USUÁRIO ATUAL
$stmt = $pdo->prepare("SELECT * FROM planos WHERE usuario_id = ? ORDER BY nome");
$stmt->execute([$_SESSION['usuario_id']]);
$planos = $stmt->fetchAll();

// Contar clientes por plano DO USUÁRIO ATUAL
$stmt = $pdo->prepare("SELECT plano_id, COUNT(*) as total FROM clientes WHERE usuario_id = ? GROUP BY plano_id");
$stmt->execute([$_SESSION['usuario_id']]);
$clientes_por_plano = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $titulo; ?> - Gestor DREEYTV</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        :root {
            --primary: #667eea;
            --secondary: #2d3748;
            --warning: #ed8936;
            --danger: #f56565;
        }
        
        body {
            background: #f5f7fa;
            color: #2d3748;
        }
        
        .admin-container {
            display: flex;
            min-height: 100vh;
        }
        
        .sidebar {
            width: 280px;
            background: var(--secondary);
            color: white;
        }
        
        .sidebar-header {
            padding: 30px 25px;
            background: rgba(0,0,0,0.2);
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        
        .sidebar-header h2 {
            font-size: 1.5rem;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .sidebar-menu {
            list-style: none;
            padding: 20px 0;
        }
        
        .sidebar-menu li {
            margin: 5px 15px;
        }
        
        .sidebar-menu a {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 15px 20px;
            color: rgba(255,255,255,0.8);
            text-decoration: none;
            border-radius: 10px;
            transition: all 0.3s;
        }
        
        .sidebar-menu a:hover {
            background: rgba(255,255,255,0.1);
            color: white;
        }
        
        .sidebar-menu a.active {
            background: var(--primary);
            color: white;
        }
        
        .main-content {
            flex: 1;
            padding: 30px;
        }
        
        .header {
            background: white;
            padding: 25px 30px;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            margin-bottom: 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .header h1 {
            font-size: 1.8rem;
            background: linear-gradient(135deg, var(--primary), #5a6fd8);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .user-avatar {
            width: 45px;
            height: 45px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--primary), #5a6fd8);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
        }
        
        .content {
            background: white;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        
        .page-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
        }
        
        .btn {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 12px 20px;
            background: var(--primary);
            color: white;
            text-decoration: none;
            border-radius: 10px;
            font-weight: 600;
            transition: all 0.3s;
            border: none;
            cursor: pointer;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
        }
        
        .btn-warning { background: var(--warning); }
        .btn-danger { background: var(--danger); }
        
        .plans-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
            gap: 25px;
        }
        
        .plan-card {
            background: white;
            padding: 25px;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            border-left: 4px solid var(--primary);
        }
        
        .plan-header {
            display: flex;
            justify-content: space-between;
            align-items: start;
            margin-bottom: 20px;
        }
        
        .plan-name {
            font-size: 1.4rem;
            color: var(--secondary);
            margin-bottom: 5px;
        }
        
        .plan-type {
            background: #c6f6d5;
            color: #22543d;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
        }
        
        .plan-price {
            text-align: right;
        }
        
        .price {
            font-size: 2rem;
            font-weight: 700;
            color: var(--primary);
        }
        
        .plan-duration {
            font-size: 0.9rem;
            color: #666;
        }
        
        .plan-creditos {
            background: #f7fafc;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 15px;
            font-size: 0.9rem;
            color: #4a5568;
        }
        
        .plan-stats {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }
        
        .clients-count {
            display: flex;
            align-items: center;
            gap: 8px;
            font-weight: 600;
            color: var(--secondary);
        }
        
        .plan-actions {
            display: flex;
            gap: 10px;
        }
        
        .plan-actions .btn {
            flex: 1;
        }
        
        .alert {
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        
        .alert-success {
            background: #c6f6d5;
            color: #22543d;
            border: 1px solid #9ae6b4;
        }
        
        .alert-danger {
            background: #fed7d7;
            color: #742a2a;
            border: 1px solid #feb2b2;
        }
        
        @media (max-width: 768px) {
            .admin-container {
                flex-direction: column;
            }
            
            .sidebar {
                width: 100%;
            }
            
            .page-header {
                flex-direction: column;
                gap: 15px;
                text-align: center;
            }
            
            .plans-grid {
                grid-template-columns: 1fr;
            }
            
            .plan-header {
                flex-direction: column;
                gap: 10px;
            }
            
            .plan-price {
                text-align: left;
            }
            
            .plan-actions {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>
    <div class="admin-container">
        <div class="sidebar">
            <div class="sidebar-header">
                <h2>📺 GESTOR DREEYTV</h2>
            </div>
            <ul class="sidebar-menu">
                <li><a href="../index.php">📊 Dashboard</a></li>
                <li><a href="../clientes/clientes.php">👨‍💼 Clientes</a></li>
                <li><a href="planos.php" class="active">📋 Planos</a></li>
                <li><a href="../servidores/servidores.php">🖥️ Servidores</a></li>
                <?php if ($_SESSION['usuario_tipo'] == 'admin'): ?>
                    <li><a href="../usuarios/usuarios.php">👥 Usuários</a></li>
                <?php endif; ?>
                <li><a href="../senha/alterar_senha.php">🔑 Alterar Senha</a></li>
                <li><a href="../logout.php">🚪 Sair</a></li>
            </ul>
        </div>
        
        <div class="main-content">
            <div class="header">
                <h1>Gestão de Planos</h1>
                <div class="user-info">
                    <div class="user-avatar"><?php echo substr($_SESSION['usuario_nome'], 0, 1); ?></div>
                    <div>
                        <div style="font-weight: 600;"><?php echo $_SESSION['usuario_nome']; ?></div>
                        <div style="font-size: 0.9rem; color: #666;"><?php echo ucfirst($_SESSION['usuario_tipo']); ?></div>
                    </div>
                    <a href="../logout.php" class="btn" style="background: var(--danger);">🚪 Sair</a>
                </div>
            </div>
            
            <div class="content">
                <div class="page-header">
                    <h2>Planos Disponíveis</h2>
                    <a href="criar_plano.php" class="btn">➕ Novo Plano</a>
                </div>

                <?php if (isset($_GET['sucesso'])): ?>
                    <div class="alert alert-success">
                        <strong>✅ Sucesso!</strong> Plano criado/editado com sucesso!
                    </div>
                <?php endif; ?>

                <?php if (isset($_GET['erro'])): ?>
                    <div class="alert alert-danger">
                        <strong>❌ Erro!</strong> Não é possível excluir um plano com clientes ativos.
                    </div>
                <?php endif; ?>

                <div class="plans-grid">
                    <?php foreach ($planos as $plano): ?>
                        <div class="plan-card">
                            <div class="plan-header">
                                <div>
                                    <div class="plan-name"><?php echo htmlspecialchars($plano['nome']); ?></div>
                                    <span class="plan-type"><?php echo htmlspecialchars($plano['tipo']); ?></span>
                                </div>
                                <div class="plan-price">
                                    <div class="price">R$ <?php echo number_format($plano['valor'], 2, ',', '.'); ?></div>
                                    <div class="plan-duration">por <?php echo $plano['dias']; ?> dias</div>
                                </div>
                            </div>

                            <?php if ($plano['creditos']): ?>
                                <div class="plan-creditos">
                                    <strong>💳 Créditos:</strong><br>
                                    <?php echo nl2br(htmlspecialchars($plano['creditos'])); ?>
                                </div>
                            <?php endif; ?>

                            <div class="plan-stats">
                                <div class="clients-count">
                                    <span>👥</span>
                                    <span><?php echo $clientes_por_plano[$plano['id']] ?? 0; ?> clientes</span>
                                </div>
                                <div style="font-size: 0.9rem; color: #666;">
                                    Criado em <?php echo date('d/m/Y', strtotime($plano['data_criacao'])); ?>
                                </div>
                            </div>

                            <div class="plan-actions">
                                <a href="editar_plano.php?id=<?php echo $plano['id']; ?>" 
                                   class="btn btn-warning">✏️ Editar</a>
                                <a href="excluir_plano.php?id=<?php echo $plano['id']; ?>&csrf_token=<?php echo $security->generateCSRFToken(); ?>" 
                                   class="btn btn-danger"
                                   onclick="return confirm('Tem certeza que deseja excluir este plano?')">
                                   🗑️ Excluir
                                </a>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>

                <?php if (empty($planos)): ?>
                    <div style="text-align: center; padding: 60px 20px; color: #666;">
                        <div style="font-size: 4rem; margin-bottom: 20px;">📄</div>
                        <h3 style="color: var(--secondary); margin-bottom: 10px;">Nenhum plano cadastrado</h3>
                        <p style="margin-bottom: 30px;">Comece criando seu primeiro plano para oferecer aos clientes.</p>
                        <a href="criar_plano.php" class="btn">➕ Criar Primeiro Plano</a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</body>
</html>